#ifndef __ZSS_H__
#define __ZSS_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Maximum number of channels (sounds) that may be played at once. */
#define MAX_CHANNELS						32

/* Max. number of semitones up or down we can transpose a song. */
#define MAX_TRANSPOSE_SEMITONES				24

/* How much the TimerScale, PitchScale fields in the ZSS_PREFS struct are scaled by. */
/* Converting floats to ints avoids the differences between 68k and PPC floats. */
#define ZSS_PREFS_FLOAT_SCALE				524288

/* Different sampling rates. */
#define RATE_44_KHZ							44100
#define RATE_33_KHZ							33075
#define RATE_22_KHZ							22050
#define RATE_11_KHZ							11025

/* Stereo types used to specify what kind of stereophony is wanted/used. */
#define USE_MONO							0
#define USE_AMIGA_STEREO					1
#define USE_FULL_STEREO						2

/* Error codes that may be returned by ZSS. */
#define ERR_NO_SND_CHANNELS					1
#define ERR_OUT_OF_MEMORY					2
#define ERR_BUF_SIZE_TOO_SMALL				3
#define ERR_GENERAL_LOADING					4
#define ERR_SONG_EOF						5
#define ERR_SONG_HEADER						6
#define ERR_SONG_BAD_MOD					7
#define ERR_SONG_PATTERN					8
#define ERR_SONG_MAKE_PATCH					9
#define ERR_SONG_SAMPLE						10
#define ERR_SONG_TOO_MANY_CHAN				11
#define ERR_SONG_BAD_FORMAT					12
#define ERR_FATAL_ERR						13
#define ERR_CREATE_PATCH					14
#define ERR_BAD_SLOT						15
#define ERR_AIFF_FILE_MANAGER				16
#define ERR_BAD_PATCH						17
#define ERR_PATCH_GENERAL					18
#define ERR_NO_DOUBLE_BUF_SUPPORT			19

/* Values returned by ZSS_GetSongType(). */
#define IS_AN_S3M							0
#define IS_A_4_MOD							1
#define IS_A_8_MOD							2
#define IS_A_CHN_MOD						3
#define IS_A_MADFG							4
#define IS_A_MADH							5
#define IS_A_15_MOD							6
#define IS_AN_XM							7
#define IS_A_MTM							8

/* Values for the "effects" field of ZSS_RETURN_CHANNEL struct. */
#define EFFECT_VOL_SLIDE		0x001
#define EFFECT_PERIOD_SLIDE		0x002
#define EFFECT_ARPEGGIO			0x004
#define EFFECT_TREMOR			0x008
#define EFFECT_VIBRATO			0x010
#define EFFECT_TREMOLO			0x020
#define EFFECT_RETRIG			0x040
#define EFFECT_NOTE_CUT			0x080
#define EFFECT_NOTE_DELAY		0x100

#if __MWERKS__
#pragma options align=native
#endif

typedef struct zss_return_patch
{
	SInt16 Bits;				/* Bits per sample: 8 or 16 */
	SInt32 Length, LoopStart;	/* Total length, and beginning of loop point */
	UInt16 UsesLoop;			/* Does this sample loop? */
	Handle SampleData;			/* Handle to the unsigned sample data */
	SInt32 BaseFreq;			/* In hetz -- works for MOD instruments, too */
	SInt16 BaseVol;				/* Base volume in [0,64] */
	SInt16 Tuning;				/* MOD tuning (this is used to find BaseFreq) */
} ZSS_RETURN_PATCH;

typedef struct zss_return_channel
{
	SInt16 pan;					/* Pan position in [-7, +7], 0 = centre. */
	SInt16 vol;					/* Current volume in [0, 64] */
	SInt16 ins;					/* Which instrument is being played (0 based) */
	SInt16 note;				/* What note is being played (in semitones?) */
	SInt32 PitchScale;			/* Playback speed (ie. pitch), scaled by ZSS_PREFS_FLOAT_SCALE. */
	UInt32 effects;				/* 1 toggle-bit per effect (see #defines above). */
	SInt32 init;				/* Is this channel initialized? */
	SInt32 PlayingNote;			/* Is this channel playing a sample? */
	UInt16 UserToggle;			/* This provides user-control over which channels are played. */
} ZSS_RETURN_CHANNEL;

#if __MWERKS__
#pragma options align=reset
#endif

#if __MWERKS__
#pragma options align=power
#endif

typedef struct zss_prefs
{
	SInt32 Rate, Stereo, Lerping, Bits, MusicVol, SFXVol;
	SInt32 TimerScale, PitchScale, PitchScale_Semitones;
} ZSS_PREFS;

#if __MWERKS__
#pragma options align=reset
#endif

extern pascal void ZSS_Shutdown( void );
extern pascal OSErr ZSS_InitMix( SInt16 TheSlot, SInt32 Rate, SInt16 Bits, SInt16 Stereo, SInt16 Lerp );
extern pascal OSErr ZSS_InitMixFromPrefs( SInt16 TheSlot, ZSS_PREFS *ThePrefs );
extern pascal OSErr ZSS_Init( SInt16 NumSFX );
extern pascal OSErr ZSS_SavePrefs( SInt16 TheSlot, ZSS_PREFS *ThePrefs );

extern pascal OSErr ZSS_LoadSong_NameVRef( SInt16 TheSlot, Str255 FName, SInt16 VRefNum );
extern pascal OSErr ZSS_LoadSong_FSSpec( SInt16 TheSlot, FSSpec *MySpec );
extern pascal OSErr ZSS_LoadSong_ResID( SInt16 TheSlot, SInt16 ResID, ResType TheType );
extern pascal OSErr ZSS_LoadSong_ResName( SInt16 TheSlot, Str255 ResName, ResType TheType );

extern pascal SInt16 ZSS_LoadSFXSample( SInt16 ID, Str255 Name );
extern pascal OSErr ZSS_DestroyPatch( SInt32 patch_num );
extern pascal void ZSS_DestroySong( SInt16 TheSlot );
extern pascal OSErr ZSS_DestroyMix( SInt16 TheSlot );

extern pascal struct CHANNEL *ZSS_PlaySFX( SInt16 PatchNum, SInt16 Vol, SInt16 Pan, SInt32 Offset, float PitchScale );
extern pascal OSErr ZSS_StartSoundOutput( SInt16 TheSlot );
extern pascal OSErr ZSS_StopSoundOutput( void );
extern pascal OSErr ZSS_StartSong( SInt16 TheSlot );
extern pascal OSErr ZSS_StopSong( SInt16 TheSlot );
extern pascal void ZSS_Goto( SInt16 TheSlot, SInt16 order, SInt16 row );
extern pascal OSErr ZSS_StartVolSlide( SInt16 Dst, float Time );
extern pascal OSErr ZSS_GetCurSlideVol( Fixed *ReturnVal );

extern pascal OSErr ZSS_GetSongPatch( SInt16 TheSlot, SInt16 ThePatchNum, ZSS_RETURN_PATCH *ThePatch );
extern pascal OSErr ZSS_GetSongName( SInt16 TheSlot, Ptr *ReturnVal );
extern pascal OSErr ZSS_GetSongType( SInt16 TheSlot, SInt16 *ReturnVal );
extern pascal OSErr ZSS_GetSongLength( SInt16 TheSlot, Fixed *ReturnVal );

extern pascal SInt32 ZSS_GetTotalMem( void );
extern pascal OSErr ZSS_GetPatchInfo( SInt16 TheSlot, SInt16 *NumSongPatches, SInt32 *SongPatchSize );
extern pascal OSErr ZSS_GetSFXPatchInfo( SInt16 *NumSFXPatches, SInt32 *SFXPatchSize );
extern pascal OSErr ZSS_GetPatInfo( SInt16 TheSlot, SInt16 *NumPatterns, SInt32 *PatSize );
extern pascal OSErr ZSS_GetTimeElapsed( SInt16 TheSlot, Fixed *ReturnVal );
extern pascal OSErr ZSS_GetDonePlaying( SInt16 TheSlot, UInt16 *ReturnVal );
extern pascal OSErr ZSS_GetNumTracks( SInt16 TheSlot, SInt16 *ReturnVal );
extern pascal OSErr ZSS_GetNumChan( SInt16 TheSlot, SInt16 *ReturnVal );
extern pascal OSErr ZSS_GetCurTrack( SInt16 TheSlot, SInt16 *ReturnVal );
extern pascal OSErr ZSS_GetCurPattern( SInt16 TheSlot, SInt16 *ReturnVal );
extern pascal OSErr ZSS_GetCurRow( SInt16 TheSlot, SInt16 *ReturnVal );
extern pascal OSErr ZSS_GetRate( SInt16 TheSlot, SInt32 *ReturnVal );
extern pascal OSErr ZSS_GetStereo( SInt16 TheSlot, SInt16 *ReturnVal );
extern pascal OSErr ZSS_GetLerping( SInt16 TheSlot, UInt16 *ReturnVal );
extern pascal OSErr ZSS_GetBits( SInt16 TheSlot, SInt32 *ReturnVal );
extern pascal OSErr ZSS_GetTranspose( SInt16 TheSlot, SInt16 *ReturnVal );
extern pascal OSErr ZSS_GetTempoScale( SInt16 TheSlot, float *ReturnVal );
extern pascal OSErr ZSS_GetMusicVol( SInt16 TheSlot, SInt16 *ReturnVal );
extern pascal OSErr ZSS_SetMusicVol( SInt16 TheSlot, SInt16 NewVol );

extern pascal SInt16 ZSS_GetSFXVol( void );
extern pascal void ZSS_SetSFXVol( SInt16 NewVol );

extern pascal OSErr ZSS_GetSlotChannel( SInt16 TheSlot, SInt16 TheChannelNum, struct CHANNEL **TheChannel );
extern pascal void ZSS_GetChannelInfo( struct CHANNEL *TheChannel, ZSS_RETURN_CHANNEL *TheChannelData );
extern pascal void ZSS_SetChannelInfo( struct CHANNEL *TheChannel, ZSS_RETURN_CHANNEL *NewData );

extern pascal void ZSS_AllowLooping( SInt16 TheSlot, UInt16 DoIt );
extern pascal void ZSS_UseTempMem( UInt16 DoIt );
extern pascal void ZSS_0VolStopsMixing( UInt16 DoIt );

extern pascal OSErr ZSS_SetTempoScale( SInt16 TheSlot, float ScaleAmt );
extern pascal OSErr ZSS_SetTranspose( SInt16 TheSlot, SInt16 Semitones );

#ifdef __cplusplus
}
#endif

#endif